from django.test import TestCase
from django.db.models.deletion import ProtectedError
from alto_django_kredit.models import Client, Transaction

class TestProtect(TestCase):
  def test_error_message_gets_translated(self):
    client = Client.objects.create(client_id = '123', card_id = '123')

    Transaction.objects.create(client = client, amount = 100, balance = 100)

    try:
      client.delete()
    except ProtectedError as error:
      assert error.args[0] == "Nemohu smazat záznam typu 'Klient', neboť na něj odkazuje reference 'Transakce.klient'"
