from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_client_auth.tests.helpers import ClientAuthHelpers, auth_header
from alto_django_kredit.models import Client
from alto_django_kredit.services import CreateTransaction

User = get_user_model()

class ListTransactionsTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    self.client1 = Client.objects.create(client_id = '123', card_id = '123',
                                         email = 'client1@test.cz')
    self.client2 = Client.objects.create(client_id = '234', card_id = '234',
                                         email = 'client2@test.cz')

    User.objects.create_user('admin', 'admin@test.cz', 'admin', is_superuser = True)
    User.objects.create_user('test1', 'test1@test.cz', 'test1', client = self.client1)
    User.objects.create_user('test2', 'test2@test.cz', 'test2', client = self.client2)

    self.admin_token   = self.get_token(username = 'admin', password = 'admin').data['token']
    self.client1_token = self.get_token(username = 'test1', password = 'test1').data['token']
    self.client2_token = self.get_token(username = 'test2', password = 'test2').data['token']

    for _ in range(3):
      CreateTransaction(client = self.client1, kind = 'KC', amount = 100)()
      CreateTransaction(client = self.client2, kind = 'KC', amount = 100)()

  def test_admin(self):
    response = self.client.get(reverse('alto_django_kredit:transactions-list'),
                               **auth_header(self.admin_token))

    self.assertEqual(len(response.data['results']['transactions']), 6)

  def test_client(self):
    response = self.client.get(reverse('alto_django_kredit:transactions-list'),
                               **auth_header(self.client1_token))

    self.assertEqual(len(response.data['results']['transactions']), 3)

    for transaction in response.data['results']['transactions']:
      self.assertEqual(transaction['client'], self.client1.id)
