import re
from decimal import Decimal
from django.urls import reverse
from selenium.webdriver.chrome.options import Options
from splinter import Browser

class ShowBalancePage:
  def __init__(self, base_url, browser = 'chrome', headless = True):
    options = Options()

    options.add_argument('--no-sandbox')
    options.add_argument('--disable-extensions')
    options.add_argument('--disable-dev-shm-usage')

    self.browser = Browser(browser, options = options, headless = headless)
    self.browser.visit(f"{base_url}{reverse('alto_django_kredit:show-balance')}")

  def __enter__(self):
    return self

  def __exit__(self, *args):
    self.browser.quit()

  def enter_card_number(self, card_number):
    self.browser.fill('card_number', card_number)

  def enter_email(self, email):
    self.browser.fill('email', email)

  def submit(self):
    self.browser.find_by_css('#show-balance-form .btn-primary').first.click()

  def enter_and_submit(self, card_number, email):
    self.enter_card_number(card_number)
    self.enter_email(email)
    self.submit()

  def get_balance(self):
    if self.browser.is_element_present_by_id('balance'):
      text    = self.browser.find_by_id('balance').first.text
      balance = re.search(r'\d+(,\d+)?', text)[0]

      return Decimal(balance.replace(',', '.'))

  def non_field_errors(self):
    selector = '#show-balance-form .alert'

    if self.browser.is_element_present_by_css(selector):
      # first two chars are '×\n' from the alert dismiss button
      return self.browser.find_by_css(selector).first.text[2:]

  def errors_for(self, field):
    selector = f'#show-balance-form .form-group.has-error input[name={field}] + .help-block'

    if self.browser.is_element_present_by_css(selector):
      return self.browser.find_by_css(selector).first.text
