import factory, factory.fuzzy, string
from alto_django_kredit.models import Client

class ClientFactory(factory.DjangoModelFactory):
  class Meta:
    model = Client

  status          = 'A'
  client_id       = factory.LazyAttribute(lambda o: o.card_id)
  card_id         = factory.Sequence(lambda n: str(n))
  chip_id         = factory.LazyAttribute(lambda o: o.card_id)
  email           = factory.LazyAttribute(
    lambda o: f'{o.firstname}_{o.surname}@test.cz'.replace(' ', '_').lower())
  firstname       = factory.Faker('first_name')
  surname         = factory.Faker('last_name')
  comment         = ''
  news            = False
  daily_menu      = False
  expiration_date = None
  personal        = factory.LazyFunction(dict)
  company         = factory.LazyFunction(dict)
  address         = factory.LazyFunction(dict)
  address2        = factory.LazyFunction(dict)
