from django.db import transaction
from django.db.models.functions import Substr
from alto_django_kredit.models  import Client, ClientInfo

class CreateMissingClientInfos:
  def __call__(self):
    base_query = Client.objects                   \
      .filter(info = None)                        \
      .annotate(prefix = Substr('card_id', 1, 1)) \
      .values_list('id', flat = True)

    infos_to_create = []

    with transaction.atomic():
      for client_id in base_query.filter(prefix__in = ['2', '3', '4']).iterator():
        info = ClientInfo(client_id = client_id, typ = 'C',
                          c_hlad       = 1,  pl_c_hlad    = 1,
                          typ_slevy    = 14, pl_typ_slevy = 14,
                          posl_poh_nul = 6,  posl_poh_arc = 6)

        infos_to_create.append(info)

        if len(infos_to_create) > 2000:
          ClientInfo.objects.bulk_create(infos_to_create)
          infos_to_create = []

      for client_id in base_query.filter(prefix = 6).iterator():
        info = ClientInfo(client_id = client_id, typ = '1',
                          c_hlad       = 1, pl_c_hlad    = 1,
                          typ_slevy    = 1, pl_typ_slevy = 1,
                          posl_poh_nul = 0, posl_poh_arc = 0)

        infos_to_create.append(info)

        if len(infos_to_create) > 2000:
          ClientInfo.objects.bulk_create(infos_to_create)
          infos_to_create = []

      ClientInfo.objects.bulk_create(infos_to_create)
