from django.forms import Form, CharField, EmailField
from django.core.exceptions import ValidationError
from django.utils.translation import gettext as _
from alto_django_kredit.settings import settings

class CardNumberField(CharField):
  def __init__(self, *args, **kwargs):
    if kwargs.get('strip') is None: kwargs['strip'] = True
    if kwargs.get('label') is None: kwargs['label'] = 'Číslo karty'

    super().__init__(*args, **kwargs)

  def validate(self, value):
    super().validate(value)

    if not settings.client_finder.is_valid_card_number(value):
      raise ValidationError(_('Not a valid card number'), code = 'invalid')

class ShowBalanceForm(Form):
  card_number = CardNumberField()
  email       = EmailField()
