import re
from pytest import mark
from alto_eet_client.results      import ConnectionFailed, RequestAccepted, CommunicationError
from alto_eet_client.tests.common import BKP_REGEX, PKP_REGEX, UUID_REGEX

class TestMakeTestRequest:
  def test_success(self, api_client, transaction):
    result = api_client.make_test_request(dic         = transaction.dic,
                                          canteen_id  = transaction.canteen_id,
                                          register_id = transaction.register_id)

    assert result.is_success
    assert isinstance(result, RequestAccepted)
    assert result.test            is True
    assert result.warning         == 'Chybna hodnota PKP'
    assert result.transaction.dic == transaction.dic
    assert result.fik             == 'ffffffff-fake-from-test-ffffffffffff-ff'
    assert re.fullmatch(BKP_REGEX,  result.bkp)
    assert re.fullmatch(PKP_REGEX,  result.pkp)
    assert re.fullmatch(UUID_REGEX, result.uuid)

  def test_unreachable_api(self, unreachable_api_client, transaction):
    result = unreachable_api_client.make_test_request(dic         = transaction.dic,
                                                      canteen_id  = transaction.canteen_id,
                                                      register_id = transaction.register_id)

    assert result.is_failure
    assert isinstance(result, ConnectionFailed)
    assert ('connection refused'    in result.detail.lower() or
            'name does not resolve' in result.detail.lower())

  @mark.skip('requires a second EET API running on localhost:8001 with incorrect `eet_server` '
             'setting, or some other obstacle when connecting to fiscal server')
  def test_fiscal_server_communication_error(self, misconfigured_api_client, transaction):
    result = misconfigured_api_client.make_test_request(dic         = transaction.dic,
                                                        canteen_id  = transaction.canteen_id,
                                                        register_id = transaction.register_id)

    assert result.is_failure
    assert isinstance(result, CommunicationError)
    assert result.transaction.dic == transaction.dic
    assert re.fullmatch(BKP_REGEX,  result.bkp)
    assert re.fullmatch(PKP_REGEX,  result.pkp)
