from os     import getenv
from pytest import fixture, mark

from alto_eet_client.client          import EETClient
from alto_eet_common.tests.factories import TransactionFactory

api_url                  = fixture(lambda: getenv('EET_API_URL',               'localhost:8000'))
misconfigured_api_url    = fixture(lambda: getenv('EET_MISCONFIGURED_API_URL', 'localhost:8001'))
unreachable_api_url      = fixture(lambda: getenv('EET_UNREACHABLE_API_URL',   'localhost:55555'))

api_client               = fixture(lambda api_url:               EETClient(api_url))
misconfigured_api_client = fixture(lambda misconfigured_api_url: EETClient(misconfigured_api_url))
unreachable_api_client   = fixture(lambda unreachable_api_url:   EETClient(unreachable_api_url))

transaction              = fixture(lambda: TransactionFactory())
invalid_transaction      = fixture(lambda: TransactionFactory(dic = 'bad dic'))
