import requests
from alto_utils.http import HTTPClient, HTTPResponse, HTTPError
from alto_eet_common.serializers.result import ResultSerializer
from alto_eet_common.serializers.transaction import TransactionSerializer
from .results import ConnectionFailed

# TODO
# - update eet project to use alto_utils and alto_eet_common and be compatible with the changes
# - merge HTTPSClient into HTTPClient, let them accept base_url with protocol and update eet project

# @returns alto_eet_client.results.RequestAccepted - transaction successfully reported
# @returns alto_eet_client.results.ConnectionFailed - couldn't establish connection to alto EET API
# @returns alto_eet_client.results.ParsingFailed - bad request format
# @returns alto_eet_client.results.SigningFailed - request couldn't be signed (missing cert, etc.)
# @returns alto_eet_client.results.CommunicationError - couldn't connect to fiscal server
# @returns alto_eet_client.results.RequestRejected - request rejected by fiscal server
class EETClient:
  def __init__(self, api_url):
    self.api_url     = api_url
    self.http_client = HTTPClient(self.api_url)

  def report_transaction(self, transaction):
    try:
      response = self.http_client.post('/eet/report_transaction',
                                       json = TransactionSerializer.to_params(transaction))

      return ResultSerializer.from_response(response).result
    except HTTPError as error:
      return ConnectionFailed(detail = str(error))

  def make_test_request(self, dic, canteen_id, register_id):
    try:
      response = self.http_client.get('/eet/test',
                                      params = { 'dic_popl':  dic,
                                                 'id_provoz': canteen_id,
                                                 'id_pokl':   register_id })

      return ResultSerializer.from_response(response).result
    except HTTPError as error:
      return ConnectionFailed(detail = str(error))
