# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_gp_webpay', 'alto_gp_webpay.test', 'alto_gp_webpay.test.pages']

package_data = \
{'': ['*'], 'alto_gp_webpay': ['schema/*']}

install_requires = \
['cryptography>=2.1.4,<2.4',
 'pydash>=4.3.2,<4.8',
 'pyyaml>=3.12,<3.14',
 'requests>=2.18.4,<2.21',
 'splinter>=0.7.7,<0.10.0',
 'zeep>=2.5.0,<2.6.0']

extras_require = \
{'test': ['requests-mock>=1.8.0,<1.9.0',
          'pytest>=6.1,<7.0',
          'pytest-cov>=2.10,<3.0'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-gp-webpay-client',
    'version': '0.1.0',
    'description': 'alto GP webpay client',
    'long_description': '# alto-gp-webpay-client\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-gp-webpay-client',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
