import requests, requests_mock
from alto_gp_webpay.config  import Config
from alto_gp_webpay.gateway import Gateway
from alto_gp_webpay.test.pages.payment import PaymentPage

class TestEcho:
  config  = Config.load()
  gateway = Gateway(config)

  def test_success(self):
    result = self.gateway.echo()

    assert result.is_success

  def test_failure(self):
    with requests_mock.Mocker() as mocker:
      mocker.register_uri(requests_mock.ANY, requests_mock.ANY,
                          exc = requests.exceptions.ConnectionError)

      result = self.gateway.echo()

      assert not result.is_success
