import time
from pydash import _
from random import randint
from urllib.parse import urlparse, parse_qs
from alto_gp_webpay.config  import Config
from alto_gp_webpay.gateway import Gateway
from alto_gp_webpay.test.pages.payment import PaymentPage

class TestCreatePayment:
  config  = Config.load()
  gateway = Gateway(config)

  def test_success(self):
    init_result    = self.gateway.create_payment(amount = 100)

    assert init_result.is_success

    url            = PaymentPage.pay(init_result.redirect)
    process_result = self.gateway.process(self._parse_query(url))

    assert process_result.is_success

  def test_card_failure(self):
    init_result    = self.gateway.create_payment(amount = 100)

    assert init_result.is_success

    url            = PaymentPage.pay(init_result.redirect, fail = True)
    process_result = self.gateway.process(self._parse_query(url))

    message        = 'Declined in AC: Card problem'
    tr_message     = 'Zamítnuto v autorizačním centru: Problém karty'

    assert not process_result.is_success
    assert process_result.message            == message
    assert process_result.translated_message == tr_message

  def _parse_query(self, url):
    query = parse_qs(urlparse(url).query)

    return _.map_values(query, _.head)
