from pydash import _
from splinter import Browser
from selenium.webdriver.chrome.options import Options

class PaymentPage:
  def __init__(self, url, browser = 'chrome', headless = True, verbose = True):
    self.verbose = verbose

    self.log('\ninitializing browser')
    options = Options()

    options.add_argument('--no-sandbox')
    options.add_argument('--disable-extensions')
    options.add_argument('--disable-dev-shm-usage')

    self.browser = Browser(browser, options = options, headless = headless)

    self.log('loading page')
    self.browser.visit(url)

  def __enter__(self):
    return self

  def __exit__(self, *args):
    self.browser.quit()

  @classmethod
  def pay(cls, redirect, fail = False):
    with cls(redirect) as page:
      page.enter_card_number()
      page.enter_month()
      page.enter_year()
      page.enter_cvc(400 if fail else 200)
      page.submit()
      page.submit_sms_code()

      return page.url

  def enter_card_number(self, number = '4056070000000008'):
    self.log('filling in card form')

    # we must insert the number in 4-digit chunks
    for pos in range(0, len(number), 4):
      self.browser.type('crdNum', number[pos:pos+4])

  def enter_cvc(self, number = 200):
    self.browser.fill('cvc', number)

  def enter_month(self, month = 12):
    self.browser.fill('exp_m', month)

  def enter_year(self, year = 22):
    self.browser.fill('exp_y', year)

  def submit(self):
    self.log('submitting card form')
    self.browser.find_by_id('send').first.click()

  def submit_sms_code(self):
    self.log('submitting sms code')
    self.browser.find_by_id('smsCodeSubmit').first.click()

  @property
  def url(self):
    return self.browser.url

  def log(self, message):
    if self.verbose: print(message)

  # def select_option(self, select_css, value):
  #   select = self.find_select(select_css)
  #   select.click()

  #   self.find_option(select, value).click()

  # def find_select(self, select_css):
  #   return self.find_with_child('.sod_select', select_css)

  # def find_option(self, select, value):
  #   return _.find(select.find_by_css('.sod_option'),
  #                 lambda option: option.text == str(value))

  # def find_with_child(self, parent_css, child_css):
  #   return _.find(self.browser.find_by_css(parent_css),
  #                 lambda select: select.find_by_css(child_css))
