import logging, logging.handlers, os, pprint

class Logger:
  separator = '=' * 80

  def __init__(self, log_dir, name = 'gp_webpay', level = logging.DEBUG):
    path      = os.path.join(log_dir, 'webpay.log')
    formatter = logging.Formatter('[%(asctime)s] %(levelname)s: %(message)s')
    handler   = logging.handlers.RotatingFileHandler(path, maxBytes = 10**6, backupCount = 5)

    handler.setLevel(level)
    handler.setFormatter(formatter)

    self.logger = logging.getLogger(name)
    self.logger.propagate = False
    self.logger.setLevel(level)

    if not self.logger.hasHandlers():
      self.logger.addHandler(handler)

  def log_result(self, result):
    self.logger.info(result)

  def log_create_payment_request(self, url, data):
    self.logger.info(self.separator)
    self.logger.info(f"creating payment with \n{pprint.pformat(data)}\n")

  def log_create_payment_response(self, response):
    self.logger.info(f"creating payment succeded with {response}:\n" +
                     f"{pprint.pformat(dict(response.headers))}\n{response.text}")

  def log_process(self, params):
    self.logger.info(self.separator)
    self.logger.info(f"processing return redirect with params \n{params}")

  def log_get_payment_status_request(self, request):
    self.logger.info(self.separator)
    self.logger.info(f"requesting payment status with\n{request}\n")

  def log_get_payment_status_response(self, response):
    self.logger.info(f"getting payment status succeeded with\n{response}\n")

  def log_get_payment_status_error(self, error):
    self.logger.error(f"getting payment status failed with\n{error}\n")
