from cryptography.hazmat.backends import default_backend
from cryptography.hazmat.primitives import serialization, hashes
from cryptography.hazmat.primitives.asymmetric import padding

class Key:
  def __init__(self, path, password = None):
    self.path     = path
    self.password = password
    self._privkey = None

  @property
  def privkey(self):
    if self._privkey: return self._privkey

    with open(self.path, 'rb') as key_file:
      self._privkey = serialization.load_pem_private_key(
        key_file.read(), password = bytes(self.password, 'utf8'), backend = default_backend())

    return self._privkey

  def sign(self, to_sign):
    return self.privkey.sign(to_sign, padding.PKCS1v15(), hashes.SHA1())
