import sys, os, yaml

if hasattr(sys, 'frozen'): # compiled by PyInstaller
  default_project_root = os.path.normpath(os.path.dirname(sys.executable))
else:
  default_project_root = os.path.normpath(os.path.join(os.path.dirname(__file__), '..'))

class Config:
  def __init__(self, project_root, config):
    self.project_root    = project_root

    self.test            = config.get('test', True)
    self.provider        = config['provider']
    self.merchant_number = config['merchant_number']
    self.return_url      = config['return_url']
    self.key_password    = config['key_password']
    self.key_path        = os.path.join(project_root, config['key_path'])
    self.log_dir         = os.path.join(project_root, config.get('log_dir', 'log'))
    self.schema_dir      = os.path.join(os.path.dirname(__file__), 'schema')
    self.schema_path     = os.path.join(self.schema_dir, 'cws_v1.wsdl')

  @classmethod
  def load(cls, project_root = default_project_root, config_path = None):
    config_path = config_path or os.getenv('GP_WEBPAY_CONFIG',
                                           os.path.join(project_root, 'config', 'config.yml'))
    config      = yaml.load(open(config_path))

    return cls(project_root, config)
