from datetime import datetime
import factory, factory.fuzzy
from alto_eet_common.models import Transaction

class TransactionFactory(factory.Factory):
  class Meta:
    model = Transaction

  dic             = 'CZ00000019'
  entrustor_dic   = factory.LazyAttribute(lambda t: t.dic)
  canteen_id      = '273'
  register_id     = '/5546/RO24'
  bill_number     = factory.Sequence(lambda n: n)
  total           = factory.Faker('pydecimal', positive = True, max_value = 10000, right_digits = 2)
  transacted_at   = factory.Faker('past_datetime', start_date="-1d")
  sent_at         = factory.LazyFunction(datetime.now)
  mode            = 0
  first_attempt   = True
  verification    = False
  vat1_base       = '0.00'
  vat1            = '0.00'
  vat2_base       = '0.00'
  vat2            = '0.00'
  vat3_base       = '0.00'
  vat3            = '0.00'
