from alto_utils.printing import Printable
from alto_utils.result_objects import Success, Failure

class ParsingFailed(Failure): pass

class EETResult(Printable):
  def __init__(self, transaction):
    self.transaction = transaction

class RequestAccepted(Success, EETResult):
  def __init__(self, transaction, *, uuid, pkp, bkp, fik,
               timestamp = None, warning = None, test = False):
    super().__init__(transaction)

    self.uuid      = uuid
    self.pkp       = pkp
    self.bkp       = bkp
    self.fik       = fik
    self.warning   = warning
    self.timestamp = timestamp
    self.test      = test

class EETFailure(Failure, EETResult): pass

class SigningFailed(EETFailure): pass

class RequestRejected(EETFailure):
  def __init__(self, transaction, *, detail):
    super().__init__(transaction = transaction, detail = "request rejected: %s" % detail)

class CommunicationError(EETFailure):
  def __init__(self, transaction, *, detail, pkp, bkp):
    super().__init__(transaction = transaction, detail = detail)

    self.pkp = pkp
    self.bkp = bkp
