from datetime import datetime
from alto_utils.printing import Printable
from alto_utils.datetime import local_to_aware

class Transaction(Printable):
  def __init__(self, *, dic, entrustor_dic = '', canteen_id, register_id, bill_number, total,
               transacted_at, sent_at = None, mode = 0,
               first_attempt = True, verification = False,
               vat1_base = None, vat1 = None, # zakladni
               vat2_base = None, vat2 = None, # 1. snizena
               vat3_base = None, vat3 = None, # 2. snizena
               used_goods_vat1 = None, used_goods_vat2 = None, used_goods_vat3 = None,
               exempt_vat_base = None, travel_services = None,
               deposit = None, withdraw = None):

    self.dic             = dic
    self.entrustor_dic   = entrustor_dic
    self.canteen_id      = canteen_id
    self.register_id     = register_id
    self.bill_number     = bill_number
    self.total           = total
    self.transacted_at   = transacted_at
    self.sent_at         = sent_at or local_to_aware(datetime.now())
    self.first_attempt   = first_attempt
    self.verification    = verification
    self.mode            = mode
    self.vat1_base       = vat1_base
    self.vat1            = vat1
    self.vat2_base       = vat2_base
    self.vat2            = vat2
    self.vat3_base       = vat3_base
    self.vat3            = vat3
    self.used_goods_vat1 = used_goods_vat1
    self.used_goods_vat2 = used_goods_vat2
    self.used_goods_vat3 = used_goods_vat3
    self.exempt_vat_base = exempt_vat_base
    self.travel_services = travel_services
    self.deposit         = deposit
    self.withdraw        = withdraw

  def __eq__(self, other):
    if isinstance(other, type(self)):
      return vars(self) == vars(other)
    return NotImplemented
