from rest_framework.response import Response
from rest_framework.decorators import api_view
from alto_django_utils.viewsets import viewset_for
from .models import BillClosing, BillHeader, BillItem, BillPayment, Sequence
from .serializers import (BillSerializer, BillClosingSerializer, BillHeaderSerializer,
                          BillItemSerializer, BillPaymentSerializer, SequenceSerializer)

BillClosingViewSet = viewset_for(BillClosing, BillClosingSerializer)
BillHeaderViewSet  = viewset_for(BillHeader,  BillHeaderSerializer)
BillItemViewSet    = viewset_for(BillItem,    BillItemSerializer)
BillPaymentViewSet = viewset_for(BillPayment, BillPaymentSerializer)
SequenceViewSet    = viewset_for(Sequence,    SequenceSerializer)

@api_view(['POST'])
def write_bill(request):
  serializer = BillSerializer(data = request.data)

  if serializer.is_valid():
    serializer.save()

    return Response(serializer.data)
  else:
    return Response(serializer.errors, status = 400)
