from django.conf.urls import url, include
from dynamic_rest.routers import DynamicRouter
from .views import BillClosingViewSet, BillHeaderViewSet, BillItemViewSet, BillPaymentViewSet
from .views import SequenceViewSet, write_bill

crud_router = DynamicRouter()

crud_router.register_resource(BillClosingViewSet)
crud_router.register_resource(BillHeaderViewSet)
crud_router.register_resource(BillItemViewSet)
crud_router.register_resource(BillPaymentViewSet)
crud_router.register_resource(SequenceViewSet)

app_name    = 'alto_django_sk'
urlpatterns = [
  url(r'^crud/', include(crud_router.urls)),
  url(r'^write_bill$', write_bill, name = 'write-bill'),
]
