from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_base_auth.tests.helpers import BaseAuthHelpers, auth_header

User = get_user_model()

class SettingsTests(APITestCase, BaseAuthHelpers):
  def setUp(self):
    User.objects.create_superuser('admin', 'admin@test.cz', 'admin')

    self.admin_token = self.get_token(username = 'admin', password = 'admin').data['token']

  def test(self):
    response = self.client.post(reverse('alto_django_sk:bill_headers-list'),
                                { 'c_uctu': 123, 'c_kas': 123 },
                                **auth_header(self.admin_token))

    assert response.status_code == 201

    response = self.client.get(reverse('alto_django_sk:bill_headers-list'),
                               **auth_header(self.admin_token))

    assert response.status_code == 200

    assert response.data['results']['bill_headers'][0]['c_uctu'] == 123
    assert response.data['results']['bill_headers'][0]['c_kas']  == 123
