from collections import namedtuple
from django.utils import timezone
from django.conf import settings
from django.db.models import (
  Model, CharField, BooleanField, DateField, DateTimeField, BigAutoField, IntegerField,
  SmallIntegerField, BigIntegerField, DecimalField, ForeignKey
)
from django.contrib.postgres.fields import JSONField
from alto_django_utils.models import PROTECT

if 'alto_django_food' in settings.INSTALLED_APPS:
  from alto_django_food.models import ProductRange, Product

  food_enabled = True
else:
  food_enabled = False

Bill = namedtuple('Bill', ['header', 'items', 'payments'])

class BillClosing(Model):
  class Meta:
    db_table = 'sk_closings'

  id         = BigAutoField(primary_key = True)
  id_old     = BigIntegerField(null = True, blank = True)
  c_kas      = IntegerField()
  c_uzaverky = IntegerField(null = True, blank = True)
  uctexport  = SmallIntegerField(null = True, blank = True)
  id_kas     = CharField(max_length = 2)
  strediska  = CharField(max_length = 20)
  odecteno   = CharField(max_length = 30, null = True, blank = True)
  uzaverka   = CharField(max_length = 17, null = True, blank = True)
  autor      = CharField(max_length = 3,  null = True, blank = True)
  mena       = CharField(max_length = 3,  null = True, blank = True)
  info_text  = CharField(max_length = 30, null = True, blank = True)
  ucetni_den = DateField()

class BillHeader(Model):
  class Meta:
    db_table = 'sk_headers'

  id         = BigAutoField(primary_key = True)
  id_old     = BigIntegerField(null = True, blank = True)
  c_kas      = IntegerField()
  closing    = ForeignKey(BillClosing, related_name = 'bills', on_delete = PROTECT,
                          null = True, blank = True)
  c_uctu     = BigIntegerField()
  pocethostu = IntegerField(null = True, blank = True)
  id_limit   = IntegerField(null = True, blank = True)
  id_den     = IntegerField(null = True, blank = True)
  id_chod    = IntegerField(null = True, blank = True)
  fucis      = IntegerField(null = True, blank = True)
  fuzcislo   = IntegerField(null = True, blank = True)
  doba_minut = SmallIntegerField(default = 0)
  pohladavka = SmallIntegerField(null = True, blank = True)
  stul       = DecimalField(max_digits = 8, decimal_places = 1, null = True, blank = True)
  round50    = DecimalField(max_digits = 4, decimal_places = 2, null = True, blank = True)
  typ        = CharField(max_length = 1,  default = 'U')
  mutace     = CharField(max_length = 1,  null = True, blank = True)
  cas_atrib  = CharField(max_length = 1,  null = True, blank = True)
  autor      = CharField(max_length = 3,  null = True, blank = True)
  fuciarkod  = CharField(max_length = 20, null = True, blank = True)
  u_cis      = CharField(max_length = 10, null = True, blank = True)
  info_text  = CharField(max_length = 30, null = True, blank = True)
  info_json  = JSONField(default = dict,  null = True, blank = True)
  cas_konce  = DateTimeField(auto_now_add = True)
  lim_datum  = DateField(null = True, blank = True)
  fuzdate    = DateField(null = True, blank = True)
  refer_id   = BigIntegerField(null = True, blank = True) # what does this refer to?
  order_id   = IntegerField(null = True, blank = True)

class BillItem(Model):
  class Meta:
    db_table = 'sk_items'

  id     = BigAutoField(primary_key = True)
  header = ForeignKey(BillHeader, related_name = 'items', on_delete = PROTECT)

  if food_enabled:
    product = ForeignKey(Product, related_name = '+', on_delete = PROTECT)
    c_data  = ForeignKey(
      ProductRange, db_column = 'c_data', default = 0,
      related_name = '+', on_delete = PROTECT
    )
  else:
    c_data = SmallIntegerField()

  c_stredisk    = IntegerField()
  c_karty       = IntegerField()
  poradi        = SmallIntegerField(default = 1)
  dil_porce     = SmallIntegerField(default = 1)
  cen_hlad      = SmallIntegerField(default = 1)
  kompez        = SmallIntegerField(null = True, blank = True)
  prachy        = DecimalField(max_digits = 12, decimal_places = 2)
  prachy_puv    = DecimalField(max_digits = 12, decimal_places = 2)
  dan           = DecimalField(max_digits = 12, decimal_places = 2)
  mnozstvi      = DecimalField(max_digits = 12, decimal_places = 3)
  stor_mno      = DecimalField(max_digits = 12, decimal_places = 3, null = True, blank = True)
  dan_sazba     = DecimalField(max_digits = 4,  decimal_places = 2)
  k_odpoctu     = CharField(max_length = 1, null = True, blank = True)
  dotacia       = CharField(max_length = 1, null = True, blank = True)
  id_fmenu      = CharField(max_length = 7, null = True, blank = True)
  order_item_id = IntegerField(null = True, blank = True)

class BillPayment(Model):
  class Meta:
    db_table = 'sk_payments'

  id        = BigAutoField(primary_key = True)
  header    = ForeignKey(BillHeader, related_name = 'payments', on_delete = PROTECT)
  kompez    = SmallIntegerField(null = True, blank = True)
  cena_pl   = DecimalField(max_digits = 12, decimal_places = 2)
  cena_mena = DecimalField(max_digits = 12, decimal_places = 2, null = True, blank = True)
  tip       = DecimalField(max_digits = 12, decimal_places = 2, null = True, blank = True)
  druh_pl   = CharField(max_length = 10)
  mena      = CharField(max_length = 3,  null = True, blank = True)
  info_text = CharField(max_length = 30, null = True, blank = True)
  info_json = JSONField(default = dict,  null = True, blank = True)
  fik       = CharField(max_length = 39, null = True, blank = True)
  bkp       = CharField(max_length = 44, null = True, blank = True)
  cas_odesl = DateTimeField(null = True, blank = True)

class Sequence(Model):
  class Meta:
    db_table = 'sk_sequences'

  name    = CharField(max_length = 32)
  counter = BigIntegerField(default = 0)
