# Generated by Django 2.0.8 on 2018-09-17 13:45

import alto_django_utils.models
from django.conf import settings
from django.db   import migrations, models

def populate_item_products(apps, schema_editor):
  Product  = apps.get_model('alto_django_food', 'Product')
  BillItem = apps.get_model('alto_django_sk',   'BillItem')

  subquery = Product.objects \
    .filter(range_id = models.OuterRef('c_data'), \
            stock_card_number = models.OuterRef('c_karty')) \
    .values('id')[:1]

  BillItem.objects.update(product_id = models.Subquery(subquery))

class Migration(migrations.Migration):
    dependencies = [
        ('alto_django_sk', '0005_change_c_data_to_fkey'),
    ]

    if 'alto_django_food' in settings.INSTALLED_APPS:
        operations = [
            migrations.AddField(
                model_name='billitem',
                name='product',
                field=models.ForeignKey(blank=True, null=True, on_delete=alto_django_utils.models.PROTECT, related_name='+', to='alto_django_food.Product'),
            ),

            migrations.RunPython(populate_item_products, migrations.RunPython.noop),

            migrations.AlterField(
                model_name='billitem',
                name='product',
                field=models.ForeignKey(on_delete=alto_django_utils.models.PROTECT, related_name='+', to='alto_django_food.Product'),
            ),
        ]
    else:
        operations = []
