# Generated by Django 2.0.8 on 2018-09-17 16:16

from django.db import migrations, models

def populate_item_c_data_from_header(apps, schema_editor):
    BillHeader = apps.get_model('alto_django_sk', 'BillHeader')
    BillItem   = apps.get_model('alto_django_sk', 'BillItem')

    subquery = BillHeader.objects.filter(id = models.OuterRef('header_id')).values('c_data')[:1]
    BillItem.objects.update(c_data = models.Subquery(subquery))

class Migration(migrations.Migration):

    dependencies = [
        ('alto_django_sk', '0003_use_translated_protect_for_fkeys'),
    ]

    operations = [
        migrations.AddField(
            model_name='billitem',
            name='c_data',
            field=models.SmallIntegerField(default=0),
        ),

        migrations.RunPython(populate_item_c_data_from_header, migrations.RunPython.noop),

        migrations.RemoveField(
            model_name='billheader',
            name='c_data',
        ),
    ]
