# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-11-02 11:56
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BillClosing',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('id_old', models.BigIntegerField(blank=True, null=True)),
                ('c_kas', models.IntegerField()),
                ('c_uzaverky', models.IntegerField(blank=True, null=True)),
                ('uctexport', models.SmallIntegerField(blank=True, null=True)),
                ('c_data', models.SmallIntegerField(default=0)),
                ('id_kas', models.CharField(max_length=2)),
                ('strediska', models.CharField(max_length=20)),
                ('odecteno', models.CharField(blank=True, max_length=30, null=True)),
                ('uzaverka', models.CharField(blank=True, max_length=17, null=True)),
                ('autor', models.CharField(blank=True, max_length=3, null=True)),
                ('mena', models.CharField(blank=True, max_length=3, null=True)),
                ('info_text', models.CharField(blank=True, max_length=30, null=True)),
                ('ucetni_den', models.DateField()),
            ],
            options={
                'db_table': 'sk_closings',
            },
        ),
        migrations.CreateModel(
            name='BillHeader',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('id_old', models.BigIntegerField(blank=True, null=True)),
                ('c_kas', models.IntegerField()),
                ('c_uctu', models.BigIntegerField()),
                ('pocethostu', models.IntegerField(blank=True, null=True)),
                ('id_limit', models.IntegerField(blank=True, null=True)),
                ('id_den', models.IntegerField(blank=True, null=True)),
                ('id_chod', models.IntegerField(blank=True, null=True)),
                ('fucis', models.IntegerField(blank=True, null=True)),
                ('fuzcislo', models.IntegerField(blank=True, null=True)),
                ('c_data', models.SmallIntegerField(default=0)),
                ('doba_minut', models.SmallIntegerField(default=0)),
                ('pohladavka', models.SmallIntegerField(blank=True, null=True)),
                ('stul', models.DecimalField(blank=True, decimal_places=1, max_digits=8, null=True)),
                ('round50', models.DecimalField(blank=True, decimal_places=2, max_digits=4, null=True)),
                ('typ', models.CharField(default='U', max_length=1)),
                ('mutace', models.CharField(blank=True, max_length=1, null=True)),
                ('cas_atrib', models.CharField(blank=True, max_length=1, null=True)),
                ('autor', models.CharField(blank=True, max_length=3, null=True)),
                ('fuciarkod', models.CharField(blank=True, max_length=20, null=True)),
                ('u_cis', models.CharField(blank=True, max_length=10, null=True)),
                ('info_text', models.CharField(blank=True, max_length=30, null=True)),
                ('info_json', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True)),
                ('cas_konce', models.DateTimeField(auto_now_add=True)),
                ('lim_datum', models.DateField(blank=True, null=True)),
                ('fuzdate', models.DateField(blank=True, null=True)),
                ('refer_id', models.BigIntegerField(blank=True, null=True)),
                ('order_id', models.IntegerField(blank=True, null=True)),
                ('sk_closing', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='bills', to='alto_django_sk.BillClosing')),
            ],
            options={
                'db_table': 'sk_headers',
            },
        ),
        migrations.CreateModel(
            name='BillItem',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('c_stredisk', models.IntegerField()),
                ('c_karty', models.IntegerField()),
                ('poradi', models.SmallIntegerField(default=1)),
                ('dil_porce', models.SmallIntegerField(default=1)),
                ('cen_hlad', models.SmallIntegerField(default=1)),
                ('kompez', models.SmallIntegerField(blank=True, null=True)),
                ('prachy', models.DecimalField(decimal_places=2, max_digits=12)),
                ('prachy_puv', models.DecimalField(decimal_places=2, max_digits=12)),
                ('dan', models.DecimalField(decimal_places=2, max_digits=12)),
                ('mnozstvi', models.DecimalField(decimal_places=3, max_digits=12)),
                ('stor_mno', models.DecimalField(blank=True, decimal_places=3, max_digits=12, null=True)),
                ('dan_sazba', models.DecimalField(decimal_places=2, max_digits=4)),
                ('k_odpoctu', models.CharField(blank=True, max_length=1, null=True)),
                ('dotacia', models.CharField(blank=True, max_length=1, null=True)),
                ('id_fmenu', models.CharField(blank=True, max_length=7, null=True)),
                ('order_item_id', models.IntegerField(blank=True, null=True)),
                ('sk_header', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='items', to='alto_django_sk.BillHeader')),
            ],
            options={
                'db_table': 'sk_items',
            },
        ),
        migrations.CreateModel(
            name='BillPayment',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('kompez', models.SmallIntegerField(blank=True, null=True)),
                ('cena_pl', models.DecimalField(decimal_places=2, max_digits=12)),
                ('cena_mena', models.DecimalField(blank=True, decimal_places=2, max_digits=12, null=True)),
                ('tip', models.DecimalField(blank=True, decimal_places=2, max_digits=12, null=True)),
                ('druh_pl', models.CharField(max_length=10)),
                ('mena', models.CharField(blank=True, max_length=3, null=True)),
                ('info_text', models.CharField(blank=True, max_length=30, null=True)),
                ('info_json', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True)),
                ('fik', models.CharField(blank=True, max_length=39, null=True)),
                ('bkp', models.CharField(blank=True, max_length=44, null=True)),
                ('cas_odesl', models.DateTimeField(blank=True, null=True)),
                ('sk_header', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='payments', to='alto_django_sk.BillHeader')),
            ],
            options={
                'db_table': 'sk_payments',
            },
        ),
        migrations.CreateModel(
            name='Sequence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=32)),
                ('counter', models.BigIntegerField(default=0)),
            ],
            options={
                'db_table': 'sk_sequences',
            },
        ),
    ]
