# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_django_client_auth',
 'alto_django_client_auth.migrations',
 'alto_django_client_auth.scripts',
 'alto_django_client_auth.services',
 'alto_django_client_auth.tests',
 'alto_django_client_auth.tests.feature',
 'alto_django_client_auth.tests.unit',
 'alto_django_client_auth.views',
 'alto_django_client_auth.views.registration']

package_data = \
{'': ['*'], 'alto_django_client_auth': ['locale/cs_CZ/LC_MESSAGES/*']}

install_requires = \
['alto-django-base-auth>=0.1,<0.2',
 'alto-django-kredit>=0.1,<0.2',
 'alto-django-utils>=0.1,<0.2',
 'django>=2.0.4,<2.1',
 'djangorestframework>=3.7.7,<3.11',
 'dynamic-rest>=2.0,<2.1',
 'pydash>=4.5.0,<4.9']

extras_require = \
{'test': ['deprecated>=1.2.5,<2.0.0',
          'factory-boy>=2.12.0,<3.0.0',
          'psycopg2-binary>=2.8.2,<2.9',
          'pyyaml>=3.12,<5.4',
          'pytest>=6.1,<7.0',
          'pytest-django>=4.1.0,<5.0.0',
          'pytest-cov>=2.10,<3.0',
          'alto-django-settings[test]>=0.1,<0.2'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-django-client-auth',
    'version': '0.1.0',
    'description': 'common django utilities for alto JSON APIs',
    'long_description': '# alto-django-client-auth\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-django-client-auth',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
