from django.conf          import settings
from django.conf.urls     import url, include
from dynamic_rest.routers import DynamicRouter

from alto_django_base_auth.views.generic import PermissionViewSet, ContentTypeViewSet, GroupViewSet
from .views.generic import UserViewSet
from .views.login   import (get_client_token, get_client_token_pair,
                            get_client_token_by_card, get_client_token_pair_by_card,
                            GetClientsForSelect)
from .views.delete  import delete_user, delete_client_user
from .views.profile import get_client, EditClient, set_client_type, is_profile_complete
from .views.registration.client_by_card  import ClientByCard
from .views.registration.register_client import RegisterClient, RegisterClientWithBV

crud_router = DynamicRouter()

app_name      = 'alto_django_client_auth'
crud_app_name = getattr(settings, 'AUTH_CRUD_APP', app_name)

if crud_app_name == app_name: # duplicated in base-auth, each resource can be only registered once
  crud_router.register_resource(UserViewSet)
  crud_router.register_resource(PermissionViewSet)
  crud_router.register_resource(ContentTypeViewSet)
  crud_router.register_resource(GroupViewSet)

def get_urlpatterns(url_name_prefix = ''):
  return [
    # registration
    url(r'^client_by_card$',           ClientByCard.as_view(),         name = f'{url_name_prefix}client-by-card'),
    url(r'^register_client$',          RegisterClient.as_view(),       name = f'{url_name_prefix}register-client'),
    url(r'^register_client_with_bv$',  RegisterClientWithBV.as_view(), name = f'{url_name_prefix}register-client-with-bv'),

    # login
    url(r'^get_client_token$',         get_client_token,               name = f'{url_name_prefix}get-client-token'),
    url(r'^get_client_token_by_card$', get_client_token_by_card,       name = f'{url_name_prefix}get-client-token-by-card'),
    url(r'^get_clients_for_select$',   GetClientsForSelect.as_view(),  name = f'{url_name_prefix}get-clients-for-select'),

    # profile
    url(r'^get_client$',               get_client,                     name = f'{url_name_prefix}get-client'),
    url(r'^edit_client$',              EditClient.as_view(),           name = f'{url_name_prefix}edit-client'),
    url(r'^set_client_type$',          set_client_type,                name = f'{url_name_prefix}set-client-type'),
    url(r'^is_profile_complete$',      is_profile_complete,            name = f'{url_name_prefix}is-profile-complete'),

    # delete
    url(r'^delete_user$',              delete_user,                    name = f'{url_name_prefix}delete-user'),
    url(r'^delete_client_user$',       delete_client_user,             name = f'{url_name_prefix}delete-client-user'),

    # CRUD
    url(r'^crud/', include(crud_router.urls))]


base_urlpatterns  = get_urlpatterns()
v1_urlpatterns    = get_urlpatterns('v1-')
v2_urlpatterns    = get_urlpatterns('v2-')
v2_urlpatterns[0] = url(
  '^get_client_token$',         get_client_token_pair,         name = 'get-client-token-pair')
v2_urlpatterns[1] = url(
  '^get_client_token_by_card$', get_client_token_pair_by_card, name = 'get-client-token-pair-by-card')


urlpatterns = [
  url(r'',     include(base_urlpatterns)),
  url(r'^v1/', include(v1_urlpatterns)),
  url(r'^v2/', include(v2_urlpatterns)),
]
