import pytest
from alto_django_utils.tests.fixtures     import api_client
from alto_django_base_auth.tests.fixtures import (
  user_defaults,
  username_credentials_factory,
  user_credentials,
  invalid_user_credentials,
  inactive_user_credentials,
  admin_user_credentials,
  user_factory,
  inactive_user,
  admin_user
)
from alto_django_kredit.tests.fixtures import (
  client_factory,
  client
)
from .helpers   import ClientAuthHelpers
from .factories import CardCredentialsFactory

@pytest.fixture
def client_auth_helpers(api_client):
  return ClientAuthHelpers(api_client)

@pytest.fixture
def card_credentials_factory():
  return CardCredentialsFactory

@pytest.fixture
def client_user_credentials(username_credentials_factory):
  return username_credentials_factory(username = 'client_user')

@pytest.fixture
def card_user_credentials(card_credentials_factory):
  return card_credentials_factory()

@pytest.fixture
def invalid_card_user_credentials(card_user_credentials):
  credentials = card_user_credentials.copy()
  credentials['password'] = 'bad' + credentials['password']

  return credentials

@pytest.fixture
def inactive_card_user_credentials(card_credentials_factory):
  return card_credentials_factory()

@pytest.fixture
def client_user(client_user_credentials, client_factory, user_factory):
  client = client_factory(firstname = 'Client', surname = 'User')

  return user_factory(**client_user_credentials, client = client, email = client.email,
                      first_name = client.firstname, last_name = client.surname)

@pytest.fixture
def card_user(card_user_credentials, client_factory, user_factory):
  client = client_factory(card_id = card_user_credentials['card_number'],
                          firstname = 'Card', surname = 'User')

  return user_factory(password = card_user_credentials['password'],
                      client = client, email = client.email, username = 'card_user',
                      first_name = client.firstname, last_name = client.surname)

@pytest.fixture
def inactive_card_user(inactive_card_user_credentials, client_factory, user_factory):
  client = client_factory(card_id = inactive_card_user_credentials['card_number'],
                          firstname = 'Inactive Card', surname = 'User')

  return user_factory(password = inactive_card_user_credentials['password'], is_active = False,
                      client = client, email = client.email, username = 'inactive_card_user',
                      first_name = client.firstname, last_name = client.surname)
