from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_kredit.models import Client
from alto_django_client_auth.tests.helpers import ClientAuthHelpers

User = get_user_model()

class PasswordChangeTests(APITestCase, ClientAuthHelpers):
  def test_cant_log_in(self):
    User.objects.create_user('test', 'test@test.cz', 'test')

    response = self.get_token('test', 'test')

    assert response.status_code == 200

    token = response.data['token']

    self.delete_user(token)

    response = self.get_token('test', 'test')

    assert response.status_code == 403

  def test_deletes_user(self):
    User.objects.create_user('test', 'test@test.cz', 'test')

    token = self.get_token('test', 'test').data['token']

    assert User.objects.count() == 1

    self.delete_user(token)

    assert User.objects.count() == 0

  def test_deletes_sensitive_client_data(self):
    client = Client.objects.create(client_id = '123', card_id = '123',
                                   firstname = 'Testy', surname = 'Testson',
                                   email     = 'test@test.cz',
                                   personal  = { 'sex': 'M' },
                                   company   = { 'name': 'Alto' },
                                   address   = { 'city': 'Prague' },
                                   address2  = { 'city': 'Brno' })

    user  = User.objects.create_user('test', 'test@test.cz', 'test', client = client)
    token = self.get_token('test', 'test').data['token']

    self.delete_user(token, clear_sensitive_data = True)

    client.refresh_from_db()

    assert not client.email
    assert client.personal == {}
    assert client.company  == {}
    assert client.address  == {}
    assert client.address2 == {}

  def test_deletes_sensitive_client_data_with_non_client_user(self):
    User.objects.create_user('test', 'test@test.cz', 'test')

    token    = self.get_token('test', 'test').data['token']
    response = self.delete_user(token, clear_sensitive_data = True)

    assert response.status_code == 400
    assert 'toto není klientský účet' in response.data['detail']
