import unittest
from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_client_auth.tests.helpers import ClientAuthHelpers, auth_header
from alto_django_kredit.models import Client

User = get_user_model()

@unittest.skip('clients no longer use CustomObjectPermissions')
class ClientTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    client = Client.objects.create(client_id = '123', card_id = '123', email = 'client@test.cz')

    self.user  = User.objects.create_user('test',  'test@test.cz',  'test', client = client)
    self.user2 = User.objects.create_user('test2', 'test2@test.cz', 'test2')
    self.admin = User.objects.create_user('admin', 'admin@test.cz', 'admin')
    self.admin.is_staff = True
    self.admin.save()

    self.user_token  = self.log_in(username = 'test',  password = 'test' ).data['token']
    self.user2_token = self.log_in(username = 'test2', password = 'test2').data['token']
    self.admin_token = self.log_in(username = 'admin', password = 'admin').data['token']
    self.client_id = client.id

  def test_list_without_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-list'))

    self.assertEqual(response.status_code, 403)
    self.assertEqual(response.data['detail'], 'Nebyly zadány přihlašovací údaje.')

  def test_list_with_user_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-list'), **auth_header(self.user_token))

    self.assertEqual(response.status_code, 403)
    self.assertEqual(response.data['detail'], 'K této akci nemáte oprávnění.')

  def test_list_with_admin_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-list'), **auth_header(self.admin_token))

    self.assertEqual(response.status_code, 200)
    self.assertEqual(response.data['results']['clients'][0]['client_id'], '123')

  def test_detail_without_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-detail', args = [self.client_id]))

    self.assertEqual(response.status_code, 403)
    self.assertEqual(response.data['detail'], 'Nebyly zadány přihlašovací údaje.')

  def test_detail_with_owning_user_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-detail', args = [self.client_id]),
                               **auth_header(self.user_token))

    self.assertEqual(response.status_code, 200)
    self.assertEqual(response.data['client']['client_id'], '123')

  def test_detail_with_other_user_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-detail', args = [self.client_id]),
                               **auth_header(self.user2_token))

    self.assertEqual(response.status_code, 403)
    self.assertEqual(response.data['detail'], 'K této akci nemáte oprávnění.')

  def test_detail_with_admin_login(self):
    response = self.client.get(reverse('alto_django_kredit:clients-detail', args = [self.client_id]),
                               **auth_header(self.admin_token))

    self.assertEqual(response.status_code, 200)
    self.assertEqual(response.data['client']['client_id'], '123')
