from datetime import date
from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_client_auth.tests.helpers import ClientAuthHelpers, auth_header
from alto_django_food.models import Product
from alto_django_sk.models import BillHeader, BillItem
from alto_django_kredit.models import Client, Transaction

today = date.today()
User  = get_user_model()

class GetTransactionsTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    self.client1    = Client.objects.create(client_id = '123', card_id = '123',
                                            email = 'client1@test.cz')
    self.client2    = Client.objects.create(client_id = '234', card_id = '234',
                                            email = 'client2@test.cz')

    self.product = Product.objects.create(name = 'test product', stock_card_number = 1,
                                     price = 100, tax_rate = 21)

    self.bill_header = BillHeader.objects.create(c_kas = 1, c_uctu = 123)
    self.bill_item   = BillItem.objects.create(header = self.bill_header, product = self.product,
                                               c_stredisk = 1, c_karty = 1, mnozstvi = 3,
                                               prachy = 121, prachy_puv = 100,
                                               dan = 21, dan_sazba = 21)

    transactions = [Transaction(client = self.client1, bill_header = self.bill_header, kind = 'KC',
                                amount = 121, balance = 121 * (i + 1)) for i in range(10)]

    self.transactions = Transaction.objects.bulk_create(transactions)

    Transaction.objects.create(client = self.client1, bill_header = self.bill_header, kind = 'XXX',
                               amount = 100, balance = 100) # bad kind

    User.objects.create_user('test', 'test@test.cz', 'test', client = self.client1)
    self.user_token = self.get_token(username = 'test',  password = 'test' ).data['token']

  def test_basic(self):
    response = self.client.get(reverse('alto_django_kredit:get-transactions'),
                               **auth_header(self.user_token))
    results  = response.data['results']

    assert response.status_code                 == 200
    assert len(results['transactions'])         == 10
    assert results['transactions'][0]['id']     == self.transactions[9].id
    assert results['bill_headers'][0]['c_uctu'] == self.bill_header.c_uctu
    assert results['bill_items'][0]['c_karty']  == self.bill_item.c_karty
    assert results['products'][0]['name']       == self.product.name

  def test_pagination(self):
    response = self.client.get(reverse('alto_django_kredit:get-transactions'),
                               {'page': 2, 'page_size': 3},
                               **auth_header(self.user_token))
    results  = response.data['results']

    assert response.status_code             == 200
    assert response.data['count']           == 10
    assert len(results['transactions'])     == 3
    assert results['transactions'][0]['id'] == self.transactions[6].id
