from django.urls import reverse
from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_kredit.models import Client, Transaction
from alto_django_client_auth.tests.helpers import ClientAuthHelpers, auth_header

User = get_user_model()

class GetBalancesTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    User.objects.create_user('admin', 'admin@test.cz', 'admin', is_superuser = True)
    self.token = self.get_token(username = 'admin', password = 'admin').data['token']

  def test(self):
    client = Client.objects.create(client_id = '123', card_id = '123', email = 'client@test.cz')

    Transaction.objects.create(client = client, kind = 'KC',  amount = '1.23', balance = '1.23')
    Transaction.objects.create(client = client, kind = 'POI', amount = '2.34', balance = '2.34')

    response = self.client.get(reverse('alto_django_kredit:get-transaction-kinds'),
                               **auth_header(self.token))

    self.assertEqual(response.status_code, 200)
    self.assertEqual(response.data['kinds'], ['KC', 'POI'])
