import pytest
from alto_django_kredit.models  import Client, ClientInfo
from alto_django_kredit.queries import CreateMissingClientInfos

@pytest.mark.django_db
class TestCreateMissingClientInfos:
  def test_success(self):
    Client.objects.bulk_create([
      Client(client_id = '111111', card_id = '111111'), # ignored
      Client(client_id = '111112', card_id = '111112'), # ignored
      Client(client_id = '211111', card_id = '211111'), # ClientInfo exists
      Client(client_id = '211112', card_id = '211112'), # ClientInfo should be created
      Client(client_id = '311111', card_id = '311111'), # ClientInfo exists
      Client(client_id = '311112', card_id = '311112'), # ClientInfo should be created
      Client(client_id = '411111', card_id = '411111'), # ClientInfo exists
      Client(client_id = '411112', card_id = '411112'), # ClientInfo should be created
      Client(client_id = '511111', card_id = '511111'), # ignored
      Client(client_id = '511112', card_id = '511112'), # ignored
      Client(client_id = '611111', card_id = '611111'), # ClientInfo exists
      Client(client_id = '611112', card_id = '611112'), # ClientInfo should be created
    ])

    infos_to_create = [
      ClientInfo(client = Client.objects.get(card_id = card_id), typ = 'C',
                 typ_slevy    = 14, pl_typ_slevy = 14,
                 posl_poh_nul = 6,  posl_poh_arc = 6)
      for card_id in ['211111', '311111', '411111']
    ]

    infos_to_create.append(
      ClientInfo(client = Client.objects.get(card_id = '611111'), typ = '1',
                 typ_slevy    = 1,  pl_typ_slevy = 1,
                 posl_poh_nul = 0,  posl_poh_arc = 0)
    )

    ClientInfo.objects.bulk_create(infos_to_create)


    CreateMissingClientInfos()()


    assert ClientInfo.objects.count() == 8
    assert ClientInfo.objects.get(client__card_id = '211112', typ = 'C',
                                  typ_slevy    = 14, pl_typ_slevy = 14,
                                  posl_poh_nul = 6,  posl_poh_arc = 6)
    assert ClientInfo.objects.get(client__card_id = '311112', typ = 'C',
                                  typ_slevy    = 14, pl_typ_slevy = 14,
                                  posl_poh_nul = 6,  posl_poh_arc = 6)
    assert ClientInfo.objects.get(client__card_id = '411112', typ = 'C',
                                  typ_slevy    = 14, pl_typ_slevy = 14,
                                  posl_poh_nul = 6,  posl_poh_arc = 6)
    assert ClientInfo.objects.get(client__card_id = '611112', typ = '1',
                                  typ_slevy    = 1,  pl_typ_slevy = 1,
                                  posl_poh_nul = 0,  posl_poh_arc = 0)
