# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_django_food', 'alto_django_food.migrations', 'alto_django_food.tests']

package_data = \
{'': ['*']}

install_requires = \
['alto-django-utils>=0.1,<0.2',
 'django>=2.0.8,<2.1.0',
 'djangorestframework>=3.7.7,<3.11',
 'dynamic-rest>=2.0.0,<2.1.0']

extras_require = \
{'test': ['pyyaml>=3.13,<5.2',
          'splinter>=0.11,<0.12',
          'psycopg2-binary>=2.8.2,<2.9',
          'pytest>=6.1,<7.0',
          'pytest-django>=4.1.0,<5.0.0',
          'pytest-cov>=2.10,<3.0',
          'alto-django-base-auth[test]>=0.1,<0.2'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-django-food',
    'version': '0.1.0',
    'description': 'django food app',
    'long_description': '# alto-django-food\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-django-food',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
