from django.db.models import Model, CharField, TextField, IntegerField, DecimalField, ForeignKey
from alto_django_utils.models import PROTECT

class ProductRange(Model):
  class Meta:
    db_table = 'product_ranges'

  name = CharField(max_length = 32, unique = True)

  def __repr__(self):
    return f"<{self.__class__.__name__} '{self.name}'>"

  def __str__(self):
    return self.name

  @classmethod
  def get_default(cls):
    return cls.objects.filter(name = 'default').first() or cls.objects.order_by('id').first()

class Product(Model):
  class Meta:
    db_table = 'products'

  range             = ForeignKey(ProductRange, related_name = 'products', default = 0,
                                 on_delete = PROTECT)
  name              = CharField(max_length = 64)
  description       = TextField(blank = True)
  stock_card_number = IntegerField(unique = True)
  price             = DecimalField(max_digits = 12, decimal_places = 2)
  price2            = DecimalField(max_digits = 12, decimal_places = 2, default = 0)
  tax_rate          = DecimalField(max_digits = 4,  decimal_places = 2)
  tax_rate2         = DecimalField(max_digits = 4,  decimal_places = 2, default = 0)

  def __repr__(self):
    return f"<{self.__class__.__name__} '{self.name}' ({self.range.name})>"

  def __str__(self):
    return self.name
