from urllib.parse import urlencode
from django.urls import reverse
from alto_django_base_auth.tests.helpers import BaseAuthHelpers, auth_header

DEFAULT_USERNAME = 'test'
DEFAULT_PASSWORD = 'Asdfghj1'

def query_params(**kwargs): return urlencode(kwargs)

class ClientAuthHelpers(BaseAuthHelpers):
  def client_by_card(self, card_number):
    path = reverse('alto_django_client_auth:client-by-card')

    return self.client.get(f'{path}?card_number={card_number}')

  def register_client(
    self, card_number, username = DEFAULT_USERNAME, password = DEFAULT_PASSWORD,
    email = None, redirect = BaseAuthHelpers.default_login_redirect,
  ):
    return self._register_client(
      username, password, email, card_number = card_number, redirect = redirect
    )

  def register_new_client(
    self, username = DEFAULT_USERNAME, password = DEFAULT_PASSWORD,
    email = None, redirect = BaseAuthHelpers.default_login_redirect,
  ):
    return self._register_client(username, password, email, redirect = redirect)

  def _register_client(self, username, password, email, **params):
    path = reverse('alto_django_client_auth:register-client')

    return self.client.post(
      f'{path}?{query_params(**params)}',
      { 'username': username, 'password': password, 'email': email },
    )

  def register_client_with_bv(
    self, card_number, username = DEFAULT_USERNAME, password = DEFAULT_PASSWORD,
    email = None, bill_number = None, bill_date = None,
    redirect = BaseAuthHelpers.default_login_redirect,
  ):
    path = reverse('alto_django_client_auth:register-client-with-bv')

    return self.client.post(
      f'{path}?{query_params(card_number = card_number, redirect = redirect)}',
      { 'username': username, 'password': password, 'email': email,
       'bill_number': bill_number, 'bill_date': bill_date },
    )

  def get_client_token(self, username, password):
    url_name = 'get-client-token-pair' if self.use_jwt else 'get-client-token'

    return self.client.post(
      reverse(f'alto_django_client_auth:{url_name}'),
      { 'username': username, 'password': password },
    )

  def get_client_token_by_card(self, card_number, password):
    url_name = 'get-client-token-pair-by-card' if self.use_jwt else 'get-client-token-by-card'

    return self.client.post(
      reverse(f'alto_django_client_auth:{url_name}'),
      { 'card_number': card_number, 'password': password },
    )

  def get_client(self, token):
    path = reverse('alto_django_client_auth:get-client')

    return self.client.get(path, **auth_header(token))

  def edit_client(self, attributes, token):
    path = reverse('alto_django_client_auth:edit-client')

    return self.client.patch(path, attributes, **auth_header(token))

  def set_client_type(self, client_type, token):
    path = reverse('alto_django_client_auth:set-client-type')

    return self.client.patch(path, { 'type': client_type }, **auth_header(token))

  def delete_user(self, token, clear_sensitive_data = False):
    path = reverse('alto_django_client_auth:delete-user')

    if clear_sensitive_data: path += '?clear_sensitive_data=true'

    return self.client.delete(path, **auth_header(token))

  def delete_client_user(self, client_id, token, clear_sensitive_data = False):
    path  = reverse('alto_django_client_auth:delete-client-user')
    path += f'?client_id={client_id}'

    if clear_sensitive_data: path += '&clear_sensitive_data=true'

    return self.client.delete(path, **auth_header(token))

  def get_barcode(self, number):
    path = reverse('alto_django_client_auth:get-barcode')

    return self.client.get(f'{path}?{query_params(number = number)}')

  def get_client_barcode(self, token):
    path = reverse('alto_django_client_auth:get-client-barcode')

    return self.client.get(path, **auth_header(token))
