from django.contrib.auth import get_user_model
from rest_framework.test import APITestCase
from alto_django_kredit.models import ClientInfo
from alto_django_kredit.serializers import ClientSerializer
from alto_django_kredit.tests.factories.client import ClientFactory
from alto_django_client_auth.tests.helpers import ClientAuthHelpers

User = get_user_model()

class GetClientTests(APITestCase, ClientAuthHelpers):
  def setUp(self):
    self.clnt = ClientFactory.create()

    User.objects.create_user('user',  'user@test.cz',  'user', client = self.clnt)
    User.objects.create_user('admin', 'admin@test.cz', 'admin', is_superuser = True)

  def test_with_no_info(self):
    token    = self.get_token(username = 'user', password = 'user').data['token']
    response = self.get_client(token)

    self.assertEqual(response.data['client'], ClientSerializer(self.clnt).data)
    self.assertEqual(response.data['type'],   None)

  def test_with_info(self):
    ClientInfo.objects.create(client = self.clnt, typ = 'A')

    token    = self.get_token(username = 'user', password = 'user').data['token']
    response = self.get_client(token)

    self.assertEqual(response.data['client'], ClientSerializer(self.clnt).data)
    self.assertEqual(response.data['type'],   'A')

  def test_with_no_client(self):
    token    = self.get_token(username = 'admin', password = 'admin').data['token']
    response = self.get_client(token)

    self.assertEqual(response.status_code, 404)
    self.assertEqual(response.data['detail'], 'Uživatel admin není asociován s žádným klientem.')
