# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_django_utils', 'alto_django_utils.management', 'alto_django_utils.tests']

package_data = \
{'': ['*'], 'alto_django_utils': ['locale/cs_CZ/LC_MESSAGES/*']}

install_requires = \
['django>=1.10.0,<2.1',
 'djangorestframework>=3.6.2,<3.11',
 'dynamic-rest>=2.0.0,<2.1.0',
 'inflection>=0.3.0,<0.4',
 'pydash>=4.1.0,<4.9']

extras_require = \
{'test': ['psycopg2-binary>=2.8.2,<2.9',
          'pyyaml>=3.12,<5.4',
          'pytest>=6.1,<7.0',
          'pytest-django>=4.1.0,<5.0.0',
          'pytest-cov>=2.10,<3.0'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-django-utils',
    'version': '0.1.0',
    'description': 'common django utilities for alto JSON APIs',
    'long_description': '# alto-django-utils\n\nalto-django-utils is a set of convenient shortcuts for quickly setting up JSON HTTP APIs based on\ndjango, DRF and dynamic-rest. The most important utility functions are:\n\n- `alto_django_utils.serializers.serializer_for` and\n- `alto_django_utils.viewsets.viewset_for`.\n\nBoth of these take the model class as the first argument (in addition to some optional ones) and\nderive from it the serializer and viewset classes, needed to build up the API, with sensible defaults.\nThese can then be registered using `dynamic_rest.routers.DynamicRouter`.\nThe resulting API supports all the advanced features of dynamic-rest\n(https://github.com/AltSchool/dynamic-rest) - complex filtering, ordering and sideloading of records\nand their relations.\n\n## Prerequisities\n### install python\n\n```bash\napt-get install -y make build-essential libssl-dev zlib1g-dev libbz2-dev \\\n  libreadline-dev libsqlite3-dev wget curl llvm libncurses5-dev libncursesw5-dev \\\n  xz-utils # tk-dev\n\ncurl -L https://raw.githubusercontent.com/pyenv/pyenv-installer/master/bin/pyenv-installer | bash\n\necho \'export PATH="/root/.pyenv/bin:$PATH"\' >> ~/.bash_profile\necho \'eval "$(pyenv init -)"\'               >> ~/.bash_profile\necho \'eval "$(pyenv virtualenv-init -)"\'    >> ~/.bash_profile\n\nsource ~/.bash_profile\n\npyenv install 3.6.5\n```\n\n### create and activate virtualenv\n\n```bash\npyenv virtualenv 3.6.5 tutor3.6.5\npyenv activate tutor3.6.5\n```\n\n### install django\n\n```bash\npip install django\n```\n\n### create and enter project\n\n```bash\ndjango-admin startproject tutor\ncd tutor\n```\n\n### add basic dependencies\n\n```bash\necho django              >> requirements.in\necho django-extensions   >> requirements.in\necho djangorestframework >> requirements.in\necho dynamic-rest        >> requirements.in\necho \'-e git+ssh://git@gitlab.apps.asrv.cz/python/alto-django-utils.git#egg=alto_django_utils\' \\\n  >> requirements.in\n```\n\n### compile and install them\n\n```bash\npip install pip-compile\npip-compile\npip install -r requirements.txt\n```\n\n### create app\n\n```bash\ndjango-admin startapp testapp\n```\n\n### register app in project\n\n```python\n# tutor/settings.py\n\nINSTALLED_APPS = [\n  \'django.contrib.admin\',\n  \'django.contrib.auth\',\n  \'django.contrib.contenttypes\',\n  \'django.contrib.sessions\',\n  \'django.contrib.messages\',\n  \'django.contrib.staticfiles\',\n  \'django_extensions\',\n  \'rest_framework\',\n  \'dynamic_rest\',\n  \'testapp\'\n]\n```\n\n## Usage\n\n### create first model\n\n```python\n# testapp/models.py\n\nfrom django.db.models import Model, CharField, DateTimeField\n\nclass Client(Model):\n  email      = CharField(\'Email\',    max_length = 64)\n  firstname  = CharField(\'Jméno\',    max_length = 32)\n  surname    = CharField(\'Příjmení\', max_length = 32)\n  created_at = DateTimeField(auto_now_add = True)\n  updated_at = DateTimeField(auto_now = True)\n```\n\n### make and apply migration\n\n```bash\n./manage.py makemigrations -n create_client\n./manage.py migrate\n```\n\n### create serializer\n\n```python\n# testapp/serializers.py\n\nfrom alto_django_utils.serializers import serializer_for\nfrom .models import Client\n\nClientSerializer = serializer_for(Client)\n```\n\n### create viewset\n\n```python\n# testapp/viewsets.py\n\nfrom alto_django_utils.viewsets import viewset_for\nfrom .models      import Client\nfrom .serializers import ClientSerializer\n\nClientViewSet = viewset_for(Client, ClientSerializer)\n```\n\n### register viewset in app urls\n\n```python\n# testapp/urls.py\n\nfrom django.conf.urls import url, include\nfrom dynamic_rest.routers import DynamicRouter\nfrom .viewsets import ClientViewSet\n\ncrud_router = DynamicRouter()\n\ncrud_router.register_resource(ClientViewSet)\n\napp_name    = \'testapp\'\nurlpatterns = [\n  url(r\'^crud/\', include(crud_router.urls)),\n]\n```\n\n### include app urls in project urls\n\n```python\n# tutor/urls.py\n\nfrom django.conf.urls import url, include\n\nurlpatterns = [\n  url(r\'^test/\', include(\'testapp.urls\')),\n]\n```\n\n### list created urls\n\n```bash\n./manage.py show_urls\n# /test/crud/clients/        views.ClientViewSet   testapp:clients-list\n# /test/crud/clients/<pk>/   views.ClientViewSet   testapp:clients-detail\n```\n\n### test created urls\n\n```bash\n./manage.py runserver # in separate shell\n\npip install httpie\n\nhttp post :8000/test/crud/clients firstname=Testy surname=Testson email=test@test.cz\nhttp get  :8000/test/crud/clients?filter{firstname.icontains}=test\n# {\n#     "count": 1,\n#     "next": null,\n#     "previous": null,\n#     "results": {\n#         "clients": [\n#             {\n#                 "id": 1,\n#                 "email": "test@test.cz",\n#                 "firstname": "Testy",\n#                 "surname": "Testson",\n#                 "created_at": "2018-04-19T03:02:16.850640Z",\n#                 "updated_at": "2018-04-19T03:02:16.850786Z"\n#             }\n#         ]\n#     }\n# }\n```\n\n### get more info at https://github.com/AltSchool/dynamic-rest\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-django-utils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
