import functools, operator, os
from collections import defaultdict

class ImproperlyConfigured(Exception): pass

NOT_PROVIDED = object()

def concat(sequences):
  return functools.reduce(operator.concat, sequences)

def lower_first(string):
  length = len(string)

  if length == 0: return ''
  if length == 1: return string.lower()
  else:           return string[0].lower() + string[1:]

def group_by(array, fun):
  result = defaultdict(list)

  for elem in array: result[fun(elem)].append(elem)

  return dict(result)

# so that we can call it as expression
def fail(error):
  raise error

def add_error(errors, keys, messages):
  if not isinstance(keys,     list): keys     = [keys]
  if not isinstance(messages, list): messages = [messages]

  for key in keys:
    if key in errors: errors[key].extend(messages)
    else: errors[key] = messages

def get_config_value(conf, variable_name, default=NOT_PROVIDED):
  value = os.getenv(variable_name, conf.get(variable_name.lower(), default))

  if value is NOT_PROVIDED: raise ImproperlyConfigured

  return value
