import pytest
from django.conf import settings
from django.contrib.auth.models import Group, Permission

pytestmark = [pytest.mark.django_db(),
              pytest.mark.skipif(not hasattr(settings, 'DEFAULT_USER_GROUPS'),
                                 reason = "DEFAULT_USER_GROUPS setting isn't set"),
              pytest.mark.skipif(not hasattr(settings, 'DEFAULT_PERMISSIONS'),
                                 reason = "DEFAULT_PERMISSIONS setting isn't set")]

def test_default_permissions_are_assigned():
  for group_name in settings.DEFAULT_USER_GROUPS:
    group = Group.objects.get(name = group_name)

    for permission_name in settings.DEFAULT_PERMISSIONS.get(group_name, []):
      app_label, codename = permission_name.split('.')

      assert (group.permissions
              .filter(content_type__app_label = app_label, codename = codename)
              .exists())
