from django.utils.translation import gettext as _
from rest_framework.views import exception_handler
from rest_framework.exceptions import APIException, ValidationError

def custom_exception_handler(exception, context):
  response = exception_handler(exception, context)

  if (response and isinstance(exception, APIException)
      and not isinstance(exception, ValidationError)
      and not 'code' in response.data):
    response.data['code'] = exception.get_codes()

  return response

class CustomAPIException(APIException):
  def __init__(self, detail = None, additional_detail = None, code = None):
    detail = detail or self.default_detail

    if additional_detail: detail = f'{detail}: {additional_detail}'

    super().__init__(detail, code)

class Misconfigured(CustomAPIException):
  status_code    = 412
  default_code   = 'misconfigured'
  default_detail = 'Misconfigured'

class MailSendingFailed(CustomAPIException):
  status_code    = 412
  default_code   = 'mail_sending_failed'
  default_detail = _('Mail sending failed')
