# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_django_canteen',
 'alto_django_canteen.lib',
 'alto_django_canteen.management',
 'alto_django_canteen.management.commands',
 'alto_django_canteen.migrations',
 'alto_django_canteen.queries',
 'alto_django_canteen.services',
 'alto_django_canteen.tests',
 'alto_django_canteen.tests.feature',
 'alto_django_canteen.tests.unit',
 'alto_django_canteen.views']

package_data = \
{'': ['*'], 'alto_django_canteen': ['locale/cs_CZ/LC_MESSAGES/*']}

install_requires = \
['alto-django-client-auth>=0.1,<0.2',
 'alto-django-kredit>=0.1,<0.2',
 'alto-django-utils>=0.1,<0.2',
 'django>=2.0.3,<2.1',
 'djangorestframework>=3.7.7,<3.11',
 'dynamic-rest>=2.0,<2.1',
 'pydash>=4.7.3,<4.8.0']

extras_require = \
{'test': ['faker>=1.0.7,<1.1.0',
          'pyyaml>=5.1,<5.2',
          'factory-boy>=2.12.0,<3.0.0',
          'psycopg2-binary>=2.8.2,<2.9.0',
          'pytest>=6.1,<7.0',
          'pytest-django>=4.1.0,<5.0.0',
          'pytest-cov>=2.10,<3.0',
          'alto-django-mailing[test]>=0.1,<0.2',
          'freezegun>=0.3.12,<0.4.0',
          'deprecated>=1.2.5,<2.0.0',
          'splinter>=0.9.0,<0.14',
          'alto-django-settings[test]>=0.1,<0.2'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0', 'pytest-testmon>=1.0.3,<2.0.0']}

setup_kwargs = {
    'name': 'alto-django-canteen',
    'version': '0.1.0',
    'description': 'django canteen app',
    'long_description': '# alto-django-canteen\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'http://gitlab.apps.asrv.cz/python/alto-django-canteen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
