from django.conf.urls import url, include
from dynamic_rest.routers import DynamicRouter

from .views.generic import (CanteenViewSet, TerminalViewSet, MealViewSet,
                            OrderViewSet, CourseViewSet, CourseGroupViewSet)
from .views.terminals import is_registered_terminal, get_terminal_token, get_terminal_token_pair
from .views.menu import LoadMenu, LoadMenuWithOrders
from .views.meal_ordering import order_meal, cancel_meal, preorder_meals
from .views.course_group_ordering import order_course_group, cancel_course_group, BulkOrder

crud_router = DynamicRouter()

crud_router.register_resource(MealViewSet)
crud_router.register_resource(OrderViewSet)
crud_router.register_resource(CourseViewSet)
crud_router.register_resource(CanteenViewSet)
crud_router.register_resource(TerminalViewSet)
crud_router.register_resource(CourseGroupViewSet)

app_name    = 'alto_django_canteen'

def get_urlpatterns(url_name_prefix = ''):
  return [
    # CRUD
    url(r'^crud/',                  include(crud_router.urls)),

    # terminal auth
    url(r'^is_registered_terminal$', is_registered_terminal,      name = f'{url_name_prefix}is-registered-terminal'),
    url(r'^get_terminal_token$',     get_terminal_token,          name = f'{url_name_prefix}get-terminal-token'),

    # loading menu
    url(r'^load_menu$',             LoadMenu.as_view(),           name = f'{url_name_prefix}load-menu'),
    url(r'^load_menu_with_orders$', LoadMenuWithOrders.as_view(), name = f'{url_name_prefix}load-menu-with-orders'),

    # ordering
    url(r'^order_meal$',            order_meal,                   name = f'{url_name_prefix}order-meal'),
    url(r'^cancel_meal$',           cancel_meal,                  name = f'{url_name_prefix}cancel-meal'),
    url(r'^preorder_meals$',        preorder_meals,               name = f'{url_name_prefix}preorder-meals'),
    url(r'^order_course_group$',    order_course_group,           name = f'{url_name_prefix}order-course-group'),
    url(r'^cancel_course_group$',   cancel_course_group,          name = f'{url_name_prefix}cancel-course-group'),
    url(r'^bulk_order',             BulkOrder.as_view(),          name = f'{url_name_prefix}bulk-order')]


base_urlpatterns  = get_urlpatterns()
v1_urlpatterns    = get_urlpatterns('v1-')
v2_urlpatterns    = get_urlpatterns('v2-')
v2_urlpatterns[2] = url(
  '^get_terminal_token$', get_terminal_token_pair, name = 'get-terminal-token-pair')


urlpatterns = [
  url(r'',     include(base_urlpatterns)),
  url(r'^v1/', include(v1_urlpatterns)),
  url(r'^v2/', include(v2_urlpatterns)),
]
