import sys
from datetime import date, timedelta
from random   import randint
from faker    import Faker
from django.apps import apps
from django.db import transaction
from django.db.models import ProtectedError
from django.core.management.base import BaseCommand
from alto_django_utils.counter import Counter

Meal    = apps.get_model('alto_django_canteen', 'Meal')
Course  = apps.get_model('alto_django_canteen', 'Course')
Canteen = apps.get_model('alto_django_canteen', 'Canteen')

fake = Faker()

def safe_encode(string):
  return string.encode('utf-8').decode(sys.getfilesystemencoding(), 'backslashreplace')

class Command(BaseCommand):
  help = 'Seed meals'

  @transaction.atomic
  def handle(self, *args, **options):
    if Canteen.objects.exists():
      try:
        Meal.objects.all().delete()

        today   = date.today()
        counter = Counter()

        for canteen in Canteen.objects.all():
          print(f'\ncreating meals for {safe_encode(canteen.name)}')

          for day in [today + timedelta(days = i) for i in range(10)]:
            if day.weekday() == 5 or day.weekday() == 6: continue

            print(f'{day}: ', end = '')

            for course in Course.objects.all():
              for i in range(randint(2, 6)):
                print(course.name[0], end = '')

                Meal.objects.create(name    = fake.sentence(5)[:64],
                                    canteen = canteen,
                                    course  = course,
                                    date    = day,
                                    number  = i + 1,
                                    stock_card_number = counter.fetch_and_add())

            print()
      except ProtectedError as e:
        print(safe_encode(e.args[0]))
    else:
      print('No canteens exist, create some first.')
