# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto_utils', 'alto_utils.tests']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.6,<3.0']

extras_require = \
{'http': ['attrs>=18.2.0,<18.3.0', 'requests>=2.19,<=2.21'],
 'test': ['flexmock>=0.10,<0.11'],
 'test-watch': ['pytest-watch>=4.2.0,<5.0.0'],
 'test-watch:python_version >= "3.6"': ['pytest-testmon>=1.0.3,<2.0.0'],
 'test:python_version >= "3.6"': ['pytest>=6.1,<7.0', 'pytest-cov>=2.10,<3.0']}

setup_kwargs = {
    'name': 'alto-utils',
    'version': '0.1.0',
    'description': 'Alto python utils',
    'long_description': '# alto-utils\n',
    'author': 'Jakub Kaláb',
    'author_email': 'jakubkalab@gmail.com',
    'maintainer': 'Jakub Kaláb',
    'maintainer_email': 'jakubkalab@gmail.com',
    'url': 'https://gitlab.apps.asrv.cz/python/alto-utils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.4,<4.0',
}


setup(**setup_kwargs)
