from lxml import etree

def from_bytes(data):
  return etree.fromstring(data)

def from_string(data):
  return from_bytes(bytes(data.strip(), 'ascii'))

def to_bytes(xml, pretty = False):
  return etree.tostring(xml, pretty_print = pretty).strip()

def to_string(xml, pretty = False):
  return str(to_bytes(xml, pretty = pretty), 'ascii')

def ns(namespace, tag_or_attr):
  return '{%s}%s' % (namespace, tag_or_attr)
