from datetime import datetime
from alto_utils.params import Params
from alto_utils.datetime import local_to_aware

def params(dic_popl = 'CZ00000019', dic_poverujiciho = 'CZ00000019', id_provoz = '11', id_pokl = '123',
           porad_cis = '12345', celk_trzba = '12.34',
           dat_trzby = None):

  dat_trzby = dat_trzby or local_to_aware(datetime.now()).isoformat()

  return Params({'dic_popl': dic_popl,
                 'dic_poverujiciho': dic_poverujiciho,
                 'id_provoz': id_provoz,
                 'id_pokl': id_pokl,
                 'porad_cis': porad_cis,
                 'celk_trzba': celk_trzba,
                 'dat_trzby': dat_trzby,
                 'prvni_zaslani': True})

class TestParams:
  def test_timestamp_conversion(self):
    winter_timestamp = params(dat_trzby = '2015-01-01T12:00:00Z').get('dat_trzby').timestamp.value
    summer_timestamp = params(dat_trzby = '2015-06-01T12:00:00Z').get('dat_trzby').timestamp.value

    assert isinstance(winter_timestamp, datetime)
    assert winter_timestamp.tzinfo.tzname(winter_timestamp) == 'CET'
    assert summer_timestamp.tzinfo.tzname(summer_timestamp) == 'CEST'
