import os, string, random, multiprocessing
from unittest import TestCase
from alto_utils.loaders import LocalLoader, RemoteLoader, LoaderError, FileNotFound

class TestLoaders(TestCase):
  def setUp(self):
    super().setUp()

    tmp_dir = os.path.join(os.path.dirname(__file__), '../../tmp')

    os.makedirs(tmp_dir, exist_ok = True)

    self.file_name = 'race_conditions.txt'
    self.file_path = os.path.join(tmp_dir, self.file_name)
    self.local_loader = LocalLoader(tmp_dir)

    open(self.file_path, 'a').close() # create if not present

  def tearDown(self):
    os.remove(self.file_path)

    super().tearDown()

  def test_avoid_race_conditions(self):

    def read_file():
      (contents, _) = self.local_loader.read_with_mtime(self.file_name)

    def write_file():
      data = ''.join(random.choice(string.ascii_lowercase + string.digits)
                     for _ in range(20))
      self.local_loader.write(self.file_name, data)

    process_count = 20
    processes      = []

    for _ in range(process_count):
      reader_process = multiprocessing.Process(target = read_file)
      reader_process.start()
      processes.append(reader_process)

      writer_process = multiprocessing.Process(target = write_file)
      writer_process.start()
      processes.append(writer_process)

    for process in processes:
      process.join()
