from .printing import Printable

# TODO: consider whether Failure should have the detail attribute
# - having custom constructors makes multiple inheritance more complex (need to pass params as kwargs,
#   need to consider order of bases, etc.)
# - if we drop it, we can revert the changes to alto_eet_common.results

class Success(Printable):
  @property
  def is_success(self):
    return True

  @property
  def is_failure(self):
    return False

class Failure(Printable):
  def __init__(self, *args, **kwargs):
    self.detail = kwargs.pop('detail', None)
    super().__init__(*args, **kwargs)

  @property
  def is_success(self):
    return False

  @property
  def is_failure(self):
    return True
